#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"
// LIST OF PRECOMPUTED SYSTEM PARAMETERS

#define KAZ_DS_SP_J				192

#define KAZ_DS_SP_g1			"65537"
#define KAZ_DS_SP_g2			"65539"

#define KAZ_DS_SP_N				"15982040643598444277320371265136974856402799594720686504760818091215333991414038871394426514903965899103553442859146701270930684879295849706045338879593833465052745734862675359470536861467492521046077102660572015"
#define KAZ_DS_SP_phiN			"2852982385092065996343896318300390927321234264319221230294884622249277900787903710363361658485275185133309433619496986167576406960701801204725152385400156421631204526170043735085154304000000000000000000000000000"

#define KAZ_DS_SP_Og1N			"12934000239870021828648909535012878456790556542848408504000"
#define KAZ_DS_SP_Og2N			"12934000239870021828648909535012878456790556542848408504000"

#define KAZ_DS_VBYTES			88
#define KAZ_DS_SBYTES			25
#define KAZ_DS_TBYTES			25
#define KAZ_DS_S1BYTES			88
#define KAZ_DS_S2BYTES			88
#define KAZ_DS_S3BYTES			88

extern void init_random();
extern void clear_random();
extern void KAZ_SIGN_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
							   const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *kaz_ds_verify_key);

#endif // FILE_H_INCLUDED
